
$(document).ready(function() {

  function make_active() { 
    if ($('#nextButton').prop('disabled') == true) {
      $('#nextButton').prop('disabled', false).css({'visibility' : 'visible', 'color' : 'black'});
    }
  };

  $('#set_value').mousedown(function() {
      make_active();
  });

  $('body').keydown(function (event) {
    if (event.keyCode == 37 || event.keyCode == 39) {
    event.preventDefault(); 
    }
  });

  $('body').keyup(function (event) {

    var knob_val = $('#set_value')
    var value = Number(knob_val.val());
    var increment = 1;

    if (event.shiftKey) { increment = 10; };
    
    switch ( event.keyCode ) {
      case 37:
        make_active();
        knob_val.val( value - increment );
        break;
      case 39: 
        make_active();
        knob_val.val( value + increment );
        break;
      case 13:
        $('#nextButton').click();
        break;
    };
  
  });

  $('#the_form').submit(function(e) {
      $.ajax({
          type: 'POST',
          url: '/study/' + url_part.exp + '/' + url_part.para + '/tryajax',
          data: JSON.stringify({
            wordLeft: $('.A').html(),
            wordRight: $('.B').html(),
            wordCenter: $('#C').html(),
            // keyboard: keybord_used,
            // dragged: mouse_used,
            // interactionCount: action_count,
            // fontLeft: $('.A').css("font-family"),
            // fontRight: $('.B').css("font-family"),
            // fontCenter: $('#C').css("font-family"),
            }),
          contentType: "application/json; charset=UTF-8",
          processData: false,
          dataType: 'json',
          success: update_the_task,
          error: function(jqXHR, textStatus, errorThrown) {
            alert('meh');
            console.log(textStatus, errorThrown);
          }
      });
      e.preventDefault();
  });
});


function update_the_task (response) {

    var random_knob = Math.floor((Math.random() * 100));

    $('.A').html(response['A']);
    $('.B').html(response['B']);
    $('#C').html(response['C']);

    $('#set_value').val(random_knob);
    $('#valueKnob').val(random_knob);
    // trialCount += 1;
    $("#nextButton").prop("disabled", true).css({"left" : "50%", "color" : "#efefef"});
  
};
